#!/usr/bin/perl -w

@F = qw (
Bah
Bee
Boo
Chh
Dah
Dee
Di
Dhin
Fah
Fee
Ga
Gah
Gay
Ka
Kah
Ki
Nah
Nu
Pha
Tah
Tee
Ti
Too
GoldfishBubble
) ;
@F = qw (
GoldfishBubble
) ;

$THRESHOLD = 350 ; #empirical
$DEPTH = 400 ;     #Number of samples to keep 
$xmin = 1 ;

foreach $f (@F)
{
  # ===============================================================================
  # Convert the .wav file into csv 
  # But only keep 30msec after threshold.
  # Take some stats while you are in there.
  # ===============================================================================
  $cmd = "./ConvertWAV2rawdata $f.wav > $f.csv" ;
  system ($cmd) ;
  $xmax = 1 ; 
  $ymin = 0 ; 
  $ymax = 0 ; 
  $signalon = 0 ;
  $ymarkmin = 0 ;
  $ymarkmax = 0 ;
  $signaloff = 0 ;
  $fifocount = 0 ;

  # ===============================================================================
  # Reading the csv ... looking for threshold, marking the x and y max vals along the way
  # ===============================================================================
  open (T, "$f.csv") ;
  open (C30, ">$f.30.csv") ;  # The C30 is the csv, 30msec
  $csv30linecount = 0 ;
  while (<T>)
  {
    $_ =~/(\d+)\s+(.*)/ ;
    $xmax = $1 ;
    $y = $2 ;
    $ymax = $y if ($ymax < $y) ;
    $ymin = $y if ($ymin > $y) ;
    $signalon = $xmax if ((($ymax > $THRESHOLD) || ($THRESHOLD < $ymin)) && ($signalon == 0)) ;

    unshift @FIFO, $y ;
    if   ($fifocount < $DEPTH) { $fifocount++ ; } 
    else                       { pop @FIFO ; }


    if (($signalon != 0) && ($signaloff == 0))
    {
      # print out the 30msec section only:
      print C30 "$csv30linecount, $y\n" ; $csv30linecount++ ;

      $counter = 0 ;
      foreach $y (@FIFO) 
      {
        $counter++ if (($y > $THRESHOLD) || ($y < -($THRESHOLD)))  ;
      }
      $signaloff = $xmax-$DEPTH if ($counter == 0) ;
    }
  }
  close(T) ;
  close(C30) ;




  # ===============================================================================
  # Use the stats and the just now generated C30 file
  # This is the .dat file for gnuplot to plot the 30 msec section
  # ===============================================================================
  $xmin = 0 ; 
  $xmax = int (0.030 * 44100) ; # .03 seconds * 44100 samples/sec
  $ymax += 400 ;                  # Just to make the plots look better
  $ymin -= 400 ;                  # Just to make the plots look better
  $ymarkmin = int (0.8 * $ymin) ; # Just to make the plots look better
  $ymarkmax = int (0.8 * $ymax) ; # Just to make the plots look better

  open (C, ">$f.dat") ;
  $gnudatstring = "set xrange [$xmin : $xmax] ; set yrange [$ymin : $ymax] ; set terminal png ; set title \"$f.30\"; set output \"$f.30.png\" ; plot \"$f.30.csv\" w lines lc 3 ; set terminal x11 ; replot" ;
  print C "$gnudatstring";
  $gnucommand = "gnuplot -background white -persist $f.dat" ;
  system $gnucommand ;
  close(C) ;




  # ===============================================================================
  # Now that I've generated one plot, give that same 30msec csv to the script that 
  # applies the asymmmetric hamming window.  
  # asym_hamming.pl produces copy.csv and copy2.csv
  # ===============================================================================
  $cmd = "cat $f.30.csv | ./asym_hamming.pl" ;  system ($cmd) ;
  $cmd = "cp copy.csv $f.30.asym_hamming.csv" ; system ($cmd) ;






  # ===============================================================================
  # Create the .dat file to plot the 30 msec section after the hamming window
  # ===============================================================================
  open (C, ">$f.30.asym_hamming.dat") ;
  $gnudatstring = "set xrange [$xmin : $xmax] ; set yrange [$ymin : $ymax] ; set terminal png ; set title \"$f.30.asym_hamming\"; set output \"$f.30.asym_hamming.png\" ; plot \"$f.30.asym_hamming.csv\" w lines lc 3 ; set terminal x11 ; replot" ;
  print C "$gnudatstring";
  $gnucommand = "gnuplot -background white -persist $f.30.asym_hamming.dat" ;
  system $gnucommand ;
  close(C) ;




  # ===============================================================================
  # Pad the output (replace with zeros and truncate) from the asymmmetric hamming 
  # window out to 2048 to give it to a DFT or an FFT
  # ===============================================================================
  system ($cmd) ;
  open (C, "copy2.csv") ;
  open (T, ">$f.30.2048.csv") ;
  $i = 0 ;

  while (<C>) 
  {
    $line = $_ ;
    last if ($i >= 2048) ;
    if      ($i < 1324) { print T "$line" ; }
    else                { print T "0\n" ; }
    $i++ ;
  }
  close(C) ;
  close(T) ;

  $cmd = "cp $f.30.2048.csv values.txt" ;                      system ($cmd) ;
  $cmd = "~/devel/Voice2MIDI/aDFT > $f.30.2048.spectrum.csv" ; system ($cmd) ;

  # Scale the spectrum, as they are wildly different. Make the 'max' value = 100.
  $maxval = 0 ; 
  open (C, "$f.30.2048.spectrum.csv") ; 
  while (<C>) 
  { 
    chomp ;
    $_ =~ /(.*?),(.*)/ ;
    $maxval = $2 if ($2 > $maxval) ;
  }
  close(C) ;

  open (N, ">scaled.csv") ;
  open (C, "$f.30.2048.spectrum.csv") ; 

  while (<C>) 
  { 
    $_ =~ /(.*?),(.*)/ ;
    $x = 100 * ($2 / $maxval) ;
    print N "$1, $x\n" ;
  }
  close(C) ;
  close(N) ;
  $cmd = "mv scaled.csv $f.30.2048.spectrum.csv" ; 
  system ($cmd) ;





  # ===============================================================================
  # Determine a good cutoff point for spectrum. That is, there are a lot of low-
  # amplitude frequency bins that clutter up the view. 
  # Add everything up to 1023, then find the line that is the first one less than 
  # 10% of the total. That gives me all the spectral line from DC that add up to
  # 90% of the total energy. (Not really an energy calculation. This little script
  # is only to provide some preliminary plots to look at.)
  # ===============================================================================
  $sum = 0 ; open (C, "$f.30.2048.spectrum.csv") ; 
  while (<C>) 
  { 
    chomp ;
    /\S+\s+(.*)/ ;
    $sum += $1 ; 
  }  
  close(C) ;

  $threshold = $sum * 0.5 * .90 ;
  $spectrum = 0 ;
  $sum = 0 ; open (C, "$f.30.2048.spectrum.csv") ; 

  while (<C>) 
  { 
    chomp ;
    /\S+\s+(.*)/ ;
    $sum += $1 ; 
    if ($sum < $threshold ) {$spectrum++ ;} 
    else                    { last; }
  } 
  close(C) ;

  $spectrum = int( 1.2 * $spectrum) ; # Just to push the plot end out a bit for looks





  # ===============================================================================
  # This creates two .dat files for gnuplot to plot the 30 msec section after the 
  # hamming window. The first uses the cutoff determined by "$spectrum" above, and
  # the second goes from 0 to 1023.
  # ===============================================================================
  for ($i = 0 ; $i < 2 ; $i++) {
  open (C, ">$f.30.2048.spectrum.dat") ;
  $gnudatstring = "set xrange [0 : $spectrum] ; set yrange [0: 110] ;set terminal png ; set title \"$f\"; set output \"$f.30.2048.spectrum.$spectrum.png\" ; set key off; " ;
  print C "$gnudatstring";

  open (T, "$f.30.2048.spectrum.csv") ;
  while (<T>)
  {
   $line = $_ ;
   $line =~ /(\S+),\s*(\S+)/;
   $freq = $1 ;
   $value = $2 ;
   print C "\nset arrow nohead from $freq,0 to $freq,$value lw 0 lc 3;" ;
  }
  close(T) ;
  print C "\nplot \"$f.30.2048.spectrum.csv\" with points pointtype 5; set terminal x11 ; replot" ;
  close(C) ;

  $gnucommand = "gnuplot -background white -persist $f.30.2048.spectrum.dat" ;
  system $gnucommand ;

  $spectrum = 1023 ;
  }
}



